/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.srcmenu;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.Instrument;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.file.FileSelectDlg;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.file.SourceMenuLoader;
import com.quantumdata.fmteditor.fmtwidgets.ConnectPanel;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.fmteditor.fmtwidgets.ListBuilder;
import com.quantumdata.fmteditor.fmtwidgets.PathSelectPanel;
import com.quantumdata.fmteditor.srcmenu.SourceMenu;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDListItem;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDProgressBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SourceMenuFrame
extends FmtFrameBase
implements ActionListener,
ItemListener,
InstrumentListener,
PropertyChangeListener {
    private static int g_nextId = 0;
    private SourceMenu m_data;
    private SourceListBuilder m_builder;
    private ConnectPanel m_conPanel;
    private QDButton m_useBtn;
    private QDButton m_resetBtn;
    private PathSelectPanel m_pathPanel;
    private boolean m_restore;
    private boolean m_firstTime = true;
    private Loader m_loader;
    private QDProgressBar m_progBar;

    public SourceMenuFrame() {
        super("", true, true, true, true);
        this.m_data = new SourceMenu();
        this.m_data.setFileName("SrcMenu" + ++g_nextId, true);
        this.initComponents();
    }

    public SourceMenuFrame(SourceMenu sourceMenu) {
        super("", true, true, true, true);
        this.m_data = sourceMenu;
        this.m_restore = true;
        this.initComponents();
    }

    private void initComponents() {
        this.setFileType(FmtFileType.MENU);
        this.setLayout(new BorderLayout());
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        qDPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        qDPanel.setPreferredSize(new Dimension(520, 350));
        this.m_builder = new SourceListBuilder();
        this.m_builder.setPickTitle(" Directory Listing ");
        this.m_builder.setBuildTitle("Source Menu Listing");
        qDPanel.add((Component)((Object)this.m_builder), (Object)"Center");
        QDPanel qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel3 = new QDPanel((LayoutManager)new BorderLayout());
        this.m_conPanel = new ConnectPanel((JComponent)((Object)this));
        this.m_conPanel.useCompactForm(true);
        qDPanel3.add((Component)((Object)this.m_conPanel), (Object)"Center");
        QDPanel qDPanel4 = new QDPanel();
        this.m_useBtn = new QDButton("Save and Use");
        this.m_useBtn.useSmallFont(true);
        this.m_useBtn.setActionCommand("use");
        this.m_useBtn.addActionListener((ActionListener)this);
        this.m_useBtn.setToolTipText("Configure the instrument to use this Source menu");
        qDPanel4.add((Component)this.m_useBtn);
        this.m_resetBtn = new QDButton("Reset Source Menu");
        this.m_resetBtn.useSmallFont(true);
        this.m_resetBtn.setActionCommand("reset");
        this.m_resetBtn.addActionListener((ActionListener)this);
        this.m_resetBtn.setToolTipText("Reset the instruments Source Menu to its default configuration");
        qDPanel4.add((Component)this.m_resetBtn);
        qDPanel3.add((Component)qDPanel4, (Object)"East");
        qDPanel2.add((Component)qDPanel3, (Object)"North");
        this.m_pathPanel = new PathSelectPanel(FmtFileType.FORMAT, this);
        this.m_pathPanel.enableTypeSelection(false);
        qDPanel2.add((Component)((Object)this.m_pathPanel), (Object)"South");
        qDPanel.add((Component)qDPanel2, (Object)"North");
        qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        this.m_progBar = new QDProgressBar();
        qDPanel2.add((Component)this.m_progBar, (Object)"Center");
        qDPanel2.add((Component)new QDLabel("  "), (Object)"East");
        qDPanel.add((Component)qDPanel2, (Object)"South");
        this.m_progBar.setVisible(false);
        this.add((Component)qDPanel);
        this.m_builder.addPropertyChangeListener("qd_modified", this);
        this.m_pathPanel.setItemListener(this);
        this.m_conPanel.setListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("use")) {
            this.saveAndUse();
        } else if (actionEvent.getActionCommand().equals("reset")) {
            this.resetMenu();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            try {
                this.m_pathPanel.writePath();
                this.m_pathPanel.readPath();
            }
            catch (InstrumentException instrumentException) {
                MsgLog.error(instrumentException.getMessage());
                this.m_conPanel.setInstrument(null);
            }
            this.loadFileList();
        }
    }

    public void connected(RemoteInstrument remoteInstrument) {
        boolean bl = remoteInstrument != null && remoteInstrument.isConnected();
        this.m_useBtn.setEnabled(bl);
        this.m_resetBtn.setEnabled(bl);
        this.m_pathPanel.setEnabled(bl);
        if (bl) {
            try {
                this.m_pathPanel.readPath();
            }
            catch (InstrumentException instrumentException) {
                MsgLog.error(instrumentException.getMessage());
                this.m_conPanel.setInstrument(null);
                return;
            }
        }
        this.loadFileList();
    }

    public void disconnected(RemoteInstrument remoteInstrument) {
        System.out.println("disconnected");
        this.m_useBtn.setEnabled(false);
        this.m_resetBtn.setEnabled(false);
        this.m_pathPanel.setEnabled(false);
        this.m_builder.clearPickList();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setFrameTitle();
    }

    public void setAsActive(boolean bl) {
        super.setAsActive(bl);
        boolean bl2 = this.isConnected();
        this.m_pathPanel.setEnabled(bl2);
        this.m_resetBtn.setEnabled(bl2);
        this.m_useBtn.setEnabled(bl2);
        if (this.m_firstTime) {
            this.m_firstTime = false;
            if (bl2) {
                try {
                    this.m_pathPanel.readPath();
                }
                catch (InstrumentException instrumentException) {
                    MsgLog.error(instrumentException.getMessage());
                    this.m_conPanel.setInstrument(null);
                    return;
                }
            }
            this.loadFileList();
        } else {
            this.maybeRestore();
        }
    }

    private void maybeRestore() {
        if (this.m_restore) {
            this.m_restore = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourceMenuFrame.this.restoreData();
                }
            });
        } else {
            this.markPicks();
        }
    }

    public void captureData() {
        this.m_data.clearNames();
        int n = this.m_builder.getBuildCount();
        for (int i = 0; i < n; ++i) {
            String string = this.m_builder.getBuildItem(i).getText();
            this.m_data.addName(string);
        }
    }

    private void restoreData() {
        this.m_builder.clearBuildList();
        int n = this.m_data.getNameCount();
        for (int i = 0; i < n; ++i) {
            String string = this.m_data.getName(i);
            this.m_builder.addBuildItem(new QDListItem(string));
        }
        this.markPicks();
        this.markUnmodified();
    }

    private void markPicks() {
        this.m_builder.unmarkAllPicks();
        if (!this.isConnected()) {
            return;
        }
        String string = this.m_pathPanel.getSelectedPath().toLowerCase();
        File file = new File(string);
        string = file.getPath();
        int n = this.m_builder.getBuildCount();
        for (int i = 0; i < n; ++i) {
            QDListItem qDListItem = this.m_builder.getBuildItem(i);
            File file2 = new File(qDListItem.getText());
            String string2 = file2.getParent();
            if (string2 == null || !string2.toLowerCase().equals(string)) continue;
            this.m_builder.markPick(file2.getName(), true);
        }
    }

    public SourceMenu getData() {
        return this.m_data;
    }

    public String getDataName() {
        return this.m_data.getFileName();
    }

    public String getRemoteDataName() {
        String string = this.getDataName();
        if (string.toLowerCase().endsWith(FmtFileType.MENU.extension())) {
            string = string.substring(0, string.length() - FmtFileType.MENU.extension().length());
            string = string + ".xml";
        }
        return string;
    }

    public String getOptTitleText() {
        if (!this.m_data.isLocal()) {
            return " (" + this.m_data.getFromIP() + ")";
        }
        return "";
    }

    public String getTypeName() {
        return "Source Menu";
    }

    public boolean isModified() {
        return this.m_builder.isModified();
    }

    public boolean isSaveable() {
        return true;
    }

    public void markUnmodified() {
        this.m_builder.markUnmodified();
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_conPanel.setInstrument(remoteInstrument);
    }

    public RemoteInstrument getInstrument() {
        return this.m_conPanel.getInstrument();
    }

    public void frameClosing() {
        this.m_conPanel.close();
    }

    public boolean isLocalFile() {
        return this.m_data.isLocal();
    }

    public boolean supportsRemoteFiles() {
        return true;
    }

    private void saveAndUse() {
        MsgLog.clearStatus();
        JFrame jFrame = (JFrame)this.getTopLevelAncestor();
        FileSelectDlg fileSelectDlg = new FileSelectDlg(jFrame, false, !this.supportsRemoteFiles(), this.getFileType(), this);
        fileSelectDlg.hideLocal();
        fileSelectDlg.setRemoteFileName(this.getRemoteDataName());
        fileSelectDlg.setVisible(true);
        if (fileSelectDlg.wasCanceled()) {
            MsgLog.msg("Save and Use Canceled");
            return;
        }
        SourceMenuLoader sourceMenuLoader = new SourceMenuLoader();
        sourceMenuLoader.save(fileSelectDlg, this, false);
        sourceMenuLoader.useAfterSave();
        FmtEditorMain.instance().getStatusPanel().showProgress("Saving and Using, please wait...");
        sourceMenuLoader.start();
    }

    private void resetMenu() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        if (remoteInstrument == null) {
            return;
        }
        MsgLog.clearStatus();
        try {
            if (Instrument.is882L(remoteInstrument)) {
                remoteInstrument.tryCommand("DIRN;DIRT FMT;DIRU");
            } else {
                remoteInstrument.tryCommand("DIRN;DIRT SOURCELIB;DIRU");
            }
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
        }
    }

    private void loadFileList() {
        if (!this.isVisible()) {
            return;
        }
        if (this.m_loader != null) {
            return;
        }
        this.m_builder.clearPickList();
        if (!this.isConnected()) {
            this.maybeRestore();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_progBar.setVisible(true);
        this.m_progBar.setIndeterminate(true);
        this.m_progBar.setStringPainted(true);
        this.m_progBar.setString("     Reading Directory     ");
        this.m_loader = new Loader();
        this.m_loader.start();
    }

    private void loadCompleted() {
        String[] stringArray;
        if (!this.m_loader.success) {
            MsgLog.error(this.m_loader.response);
            this.m_progBar.setIndeterminate(false);
            this.m_progBar.setVisible(false);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.m_loader = null;
            this.maybeRestore();
            return;
        }
        for (String string : stringArray = this.m_loader.response.split("\r\n")) {
            if ((string = string.trim()).length() <= 0) continue;
            this.m_builder.addPickItem(new QDListItem(string));
        }
        this.m_progBar.setIndeterminate(false);
        this.m_progBar.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.m_loader = null;
        this.maybeRestore();
    }

    private class SourceListBuilder
    extends ListBuilder {
        public void addSelected(QDListItem qDListItem) {
            String string = this.getFullName(qDListItem.getText());
            if (string == null) {
                return;
            }
            this.addBuildItem(new QDListItem(string));
            qDListItem.setMarked(true);
            this.repaint();
        }

        protected boolean itemDropped(String string, int n) {
            if (!string.startsWith("/")) {
                SourceMenuFrame.this.m_builder.markPick(string, true);
                string = this.getFullName(string);
                if (string == null) {
                    return false;
                }
            }
            this.addBuildItem(new QDListItem(string), n);
            return true;
        }

        protected void removeSelected(QDListItem qDListItem) {
            File file = new File(qDListItem.toString());
            this.removeBuildItem(qDListItem, file.getName());
        }

        protected String getFullName(String string) {
            RemoteInstrument remoteInstrument = SourceMenuFrame.this.getInstrument();
            if (remoteInstrument == null) {
                return string;
            }
            try {
                SourceMenuFrame.this.m_pathPanel.writePath();
                remoteInstrument.tryCommand("FMTL " + string + " 1");
                string = remoteInstrument.tryQuery("FMTL?");
            }
            catch (InstrumentException instrumentException) {
                if (instrumentException.timedOut()) {
                    SourceMenuFrame.this.m_conPanel.setInstrument(null);
                    MsgLog.error(instrumentException.getMessage());
                } else {
                    MsgLog.error("Invalid Format: Check the XML file type or path");
                }
                return null;
            }
            return string;
        }
    }

    private class Loader
    extends Thread {
        public String response = "";
        public boolean success = false;

        private Loader() {
        }

        public void run() {
            try {
                RemoteInstrument remoteInstrument = SourceMenuFrame.this.getInstrument();
                String string = SourceMenuFrame.this.m_pathPanel.getType().getCmdType() + "Q? 1 999";
                this.response = remoteInstrument.tryQuery(string, 120000);
                this.success = true;
            }
            catch (InstrumentException instrumentException) {
                this.response = instrumentException.getMessage();
                this.success = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourceMenuFrame.this.loadCompleted();
                }
            });
        }
    }
}

